capture program drop importData
program define importData

version 13.1
*! version 1.0 January 22, 2016

args sourceData sourceMetaData destination 

*Checking the correct syntax
if "`sourceData'"=="" | "`sourceMetaData'"==""  | "`destination'"=="" {
display ""
display "	Incorrect number of source and destination tables specified."
display "	Rerun the program specifying a source data and metadata table and a destination table."
help importData
exit
}

if "`destination'"!="INDIVIDUAL_EXT" & "`destination'"!="INDIVIDUAL_EXT.dta" & "`destination'"!="CONTEXT_EXT.dta" & "`destination'"!="CONTEXT_EXT"{
display ""
display "	`destination'" " is not a correct destination table."
display "	Rerun the program specifying a source data and metadata table and INDIVIDUAL_EXT or CONTEXT_EXT as a destination table."
help importData
exit
}



display ""
display "Start of the program IMPORT DATA"

*Display version number of the program
which importData
display ""


display "	Part 1: Checking that the source and destination tables are found."

*Check if the source and destination tables are found
qui capture use `sourceData', clear
	if _rc!=0{
	display "	File `source' not found."
	display "	The program IMPORT DATA was stopped."
	help importData
	qui exit
	}
	
qui capture use `sourceMetaData', clear
	if _rc!=0{
	display "	File `sourceMetaData' not found."
	display "	The program IMPORT DATA was stopped."
	help importData
	qui exit
	}

qui capture use `destination', clear
	if _rc!=0{
	display "	File `destination' not found. Run the program IDSextended to create it."
	display "	The program IMPORT DATA was stopped."
	help importData
	qui exit
	}
		
qui capture use METADATA, clear
	if _rc!=0{
	display "	File METADATA.dta not found. Run the program IDSextended to create it."
	display "	The program IMPORT DATA was stopped."
	help importData
	qui exit
	}
		

		
		
		
display "	Part 2: Checking whether the source tables contain the correct fields."

use `sourceData',clear

*Fields that should be contained in INDIVIDUAL_EXT and CONTEXT_EXT
qui gen i = 1 
qui gen problem = 0 
foreach VarName in Value Day Month Year DayFrac { 
	local j = i	
	capture confirm variable `VarName' 
	if !_rc{
	local missing`j' = ""
	}
	else{
	local missing`j' = "`VarName'"
	qui replace problem = 1
	}
	qui: replace i = i+1
}
drop i 

*Fields that should be contained in INDIVIDUAL_EXT
if "`destination'" =="INDIVIDUAL_EXT" | "`destination'" =="INDIVIDUAL_EXT.dta" {
qui gen i = 1 
foreach VarName in Id_I Date_type { 
	local j = i	
	capture confirm variable `VarName' 
	if !_rc{
	local missingIND`j' = ""
	}
	else{
	local missingIND`j' = "`VarName'"
	qui replace problem = 1
	}
	qui: replace i = i+1
}
drop i 
local missingCONT1 = ""
}

*Fields that should be contained in CONTEXT_EXT
if "`destination'" =="CONTEXT_EXT" | "`destination'" =="CONTEXT_EXT.dta" {

qui gen i = 1 
foreach VarName in Id_C { 
	local j = i	
	capture confirm variable `VarName' 
	if !_rc{
	local missingCONT`j' = ""
	}
	else{
	local missingCONT`j' = "`VarName'"
	qui replace problem = 1
	}
	qui: replace i = i+1
}
drop i 
local missingIND1 = ""
local missingIND2 = ""
}

*Display error message
if problem == 1 {
display ""
display "	The source file `source' is not compatible."
display "	Missing column: " "`missing1'" " " "`missing2'" " " "`missing3'" " " "`missing4'" " " "`missing5'" " " "`missing6'" " " "`missingIND1'" " " "`missingIND2'" " " "`missingCONT1'" 
display "	Fix the file and restart the program."
exit 
}
if problem == 0 {
display "	The source file `source' contains the correct fields. The program will continue running."
}

qui drop problem




use `sourceMetaData',clear

qui gen i = 1 
qui gen problem = 0 
foreach VarName in Type Value { 
	local j = i	
	capture confirm variable `VarName' 
	if !_rc{
	local missing`j' = ""
	}
	else{
	local missing`j' = "`VarName'"
	qui replace problem = 1
	}
	qui: replace i = i+1
}
drop i 
*Display error message
if problem == 1 {
display ""
display "	The metadata source file `sourceMeta' is not compatible."
display "	Missing column: " "`missing1'" " " "`missing2'"  
display "	Fix the file and restart the program."
exit 
}
if problem == 0 {
display "	The metadata source file `sourceMeta' contains the correct fields. The program will continue running."
}

qui drop problem




display "	Part 3: Dropping fields not relevant to the destination tables."

use `sourceData',clear

*Optional fields in INDIVIDUAL_EXT and CONTEXT_EXT
qui{
qui gen i = 1 
foreach VarName in Source Id_D { 
	local j = i	
	capture confirm variable `VarName' 
	if !_rc{
	}
	else{
	gen `VarName' = ""
	}
	qui: replace i = i+1
}
drop i 
}

*Optional fields in INDIVIDUAL_EXT
qui{
if "`destination'" =="INDIVIDUAL_EXT" | "`destination'" =="INDIVIDUAL_EXT.dta" {
qui gen i = 1 
foreach VarName in Value_Id_C { 
	capture confirm variable `VarName' 
	if !_rc{
	destring Value_Id_C, replace
	}
	else{
	gen Value_Id_C = .
	}
	qui: replace i = i+1
}
drop i 
}
}

*Optional fields in CONTEXT_EXT
qui{
if "`destination'" =="CONTEXT_EXT" | "`destination'" =="CONTEXT_EXT.dta" {
qui gen i = 1 
foreach VarName in Date_type { 
	local j = i	
	capture confirm variable `VarName' 
	if !_rc{
	}
	else{
	gen Date_type= ""
	}
	qui: replace i = i+1
}
drop i 
}
}

*Drop fields that are not found in INDIVIDUAL_EXT and CONTEXT_EXT
qui{

if "`destination'" =="INDIVIDUAL_EXT" | "`destination'" =="INDIVIDUAL_EXT.dta"{

capture keep Type Value Day Month Year DayFrac Id_I Date_type Source Id_D Value_Id_C Start_day Start_month Start_year End_day End_month End_year
if _rc!=0{
keep Type Value Day Month Year DayFrac Id_I Date_type Source Id_D Value_Id_C
}


}		

if "`destination'" =="CONTEXT_EXT" | "`destination'" =="CONTEXT_EXT.dta" {

capture keep Type Value Day Month Year DayFrac Id_C Source Id_D Date_type Start_day Start_month Start_year End_day End_month End_year
if _rc!=0{
keep Type Value Day Month Year DayFrac Id_C Source Id_D Date_type
}

}

tempfile source1
save `source1', replace

}



qui{
*Optional fields in METADATA table
use `sourceMetaData',clear
qui gen i = 1 
foreach VarName in Source Id_D Type_T Extract Explanation { 
	local j = i	
	capture confirm variable `VarName' 
	if !_rc{
	}
	else{
	gen `VarName' = ""
	}
	qui: replace i = i+1
}
drop i 

*Dropping fields not relevant to the METADATA table. 
keep Id_D Type Value Source Type_T Extract Explanation

foreach VarName in Source Id_D Type_T Extract Explanation { 
tostring `VarName', replace
}

tempfile sourceMeta1
save `sourceMeta1', replace
}

display "	Part 4: Appending source information to destination tables."

*Append source information to destination table		
qui{
use `source1', clear
append using `destination', force
save `destination', replace

use `sourceMeta1', clear
append using METADATA, force
save METADATA, replace

}

display ""
display "End of the program IMPORT DATA. File `source' appended to the `destination' and METADATA tables."

end
